package cn.com.duiba.kjy.api.remoteservice.seller;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.whosawme.CustOriginHBDto;
import cn.com.duiba.kjy.api.dto.whosawme.SellerCustOriginBo;
import cn.com.duiba.kjy.api.dto.seller.SellerCustomerOriginDto;
import cn.com.duiba.kjy.api.params.seller.SellerCustomerOriginQryParam;
import cn.com.duiba.kjy.api.params.whosawme.CustOriginParam;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @author wangbinbin
 * @create 2019/7/1 10:07
 * @descript
 */
@AdvancedFeignClient
public interface RemoteSellerCustomerOriginService {

    /**
     * 根据参数查询列表
     * @param param
     * @return
     */
    List<SellerCustomerOriginDto> listByParams(SellerCustomerOriginQryParam param);

    /**
     * 查询最新一条记录
     * @param param
     * @return
     */
    SellerCustomerOriginDto findOneByParams(SellerCustomerOriginQryParam param);

    /**
     * 保存访问来源记录
     * @param sellerCustomerOriginDto
     * @return
     */
    Integer saveOrigin(SellerCustomerOriginDto sellerCustomerOriginDto);

    /**
     * 获取访客最早的一条来源记录
     * @param param
     * @return
     */
    SellerCustomerOriginDto getFirstVisitRecord(CustOriginParam param);

    /**
     * 获取客户上级来源信息
     * @param param
     * @return
     */
    SellerCustomerOriginDto getOriginVisitRecord(CustOriginParam param);

    /**
     * 获取客户来源
     * @param sellerId
     * @param sellerUserId
     * @return
     */
    SellerCustOriginBo getCustOrigin(Long sellerId, Long sellerUserId);


    /**
     * 获取客户来源
     * @param sellerId
     * @param sellerUserId
     * @param visitorIds 指定的访客Id
     * @return
     */
    SellerCustOriginBo getCustOrigin4SpecificVisitor(Long sellerId, Long sellerUserId,List<Long> visitorIds);


    /**
     * 根据userId 获取用户来源
     * @param sellerId
     * @param sellerUserId
     * @param extraResource
     * @return
     */
    Map<Long, CustOriginHBDto> getUserId2OriginMap(Long sellerId, Long sellerUserId, Set<Long> extraResource);

    /**
     * 重置访客来源信息
     * @param sellerIds
     * @param visitorId
     * @return
     */
    void delCustOrigin(List<Long> sellerIds,Long visitorId);

    /**
     * 新增  返回主键
     * @param sellerCustomerOriginDto
     * @return
     */
    Long addSellerCustomerOrigin(SellerCustomerOriginDto sellerCustomerOriginDto);


    /**
     * 根据主键删除
     * @param ids
     * @return
     */
    Integer deleteByIds(List<Long> ids);

    /**
     * 根据主键查找
     * @param id
     * @return
     */
    SellerCustomerOriginDto findById(Long id);

}
