package cn.com.duiba.kjy.api.remoteservice.version;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.version.VersionItemConfBean;
import cn.com.duiba.kjy.api.dto.version.VersionItemConfDto;

import java.util.List;

/**
 * 版本配置 rpc服务
 * @author 吴文哲
 * @date 2020-04-23 14:49
 **/
@AdvancedFeignClient
public interface RemoteVersionItemConfService {

    /**
     * 根据类型和版本查询itemid列表
     * @param type
     * @param version
     * @return
     */
    List<Long> findItemIdsByTypeAndVersion(String type, Integer version);


    /**
     * 根据类型和版本查询列表
     * @param type
     * @param version
     * @return
     */
    List<VersionItemConfDto> findByTypeAndVersion(String type, Integer version);

    /**
     * 批量更新item
     * @param beanList
     * @return
     */
    Boolean batchUpdateItemConf(List<VersionItemConfBean> beanList);


}
