package cn.com.duiba.kjy.api.enums.accurate;

import java.util.stream.Stream;

/**
 * 精准素材库内容类型
 * @author xiaotian
 * @date 2019-11-14 16:49
 **/
public enum AccurateContentTypeEnum {

    /**
     * 文章
     */
    ARTICLE(1, "article","文章"),

    /**
     * 动画
     */
    CARTOON(2, "cartoon","动画"),
    /**
     * 小游戏
     */
    GAME(3, "game","小游戏"),

    /**
     * 活动
     */
    ACTIVITY(4,"activity","活动"),

    /**
     * 视频
     */
    VIDEO(5,"video","视频"),
    ;

    private Integer code;

    private String type;

    private String desc;

    AccurateContentTypeEnum(Integer code, String type, String desc) {
        this.code = code;
        this.type = type;
        this.desc = desc;
    }

    public static AccurateContentTypeEnum getByCode(Integer code){
        return Stream.of(AccurateContentTypeEnum.values()).filter(accurateContentTypeEnum -> accurateContentTypeEnum.getCode().equals(code)).findFirst().orElse(ARTICLE);
    }

    public static AccurateContentTypeEnum getByType(String type){
        return Stream.of(AccurateContentTypeEnum.values()).filter(accurateContentTypeEnum -> accurateContentTypeEnum.getType().equals(type)).findFirst().orElse(ARTICLE);
    }

    public Integer getCode() {
        return code;
    }

    public String getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }
}
