package cn.com.duiba.kjy.api.dto.sellercard;

import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;

/**
 * 通用版 客户案例
 *
 * @author 吴文哲
 * @date 2020-02-26 18:51
 **/
@Data
public class CaseDto4CommonVersion implements Serializable {
    private static final long serialVersionUID = 3571934804731481844L;


    /**
     * 代理人id
     */
    private Long sellerId;

    /**
     * HBase key
     */
    private String id;

    /**
     * 客户姓名
     */
    private String name;

    /**
     * 购买产品
     */
    private String product;

    /**
     * 案例描述
     */
    private String caseIntro;

    /**
     * 案例图片
     */
    private String casePics;

    /**
     * 必填项是否完善
     */
    private boolean complete;


    public void setComplete() {
        if (StringUtils.isBlank(this.name) || StringUtils.isBlank(this.product) || StringUtils.isBlank(this.casePics)|| StringUtils.isBlank(this.caseIntro)) {
            this.complete = false;
        }
        this.complete = true;
    }

    /**
     * 用户版本
     *
     * @see cn.com.duiba.kjy.api.enums.version.UserVersionEnum
     */
    private Integer userVersion;



}
