package cn.com.duiba.kjy.api.dto.sellercard;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 代理人名片评价表
 * @author kjj mybatis generator 
 * 2020-03-17
 */
@Data
public class SellerCardAppraiseDto implements Serializable {
    private static final long serialVersionUID = 15844273461832557L;

    /**
     *
     *主键
     * not null default = null
     */
    private Long id;

    /**
     *
     *tb_seller.id
     * not null default = null
     */
    private Long sellerId;

    /**
     *
     *tb_users.id
     * not null default = null
     */
    private Long visitorId;

    /**
     *
     *客户评价内容
     * max length = 190
     * not null default = 
     */
    private String content;

    /**
     *
     *评价星级
     * not null default = 5
     */
    private Integer star;

    /**
     *
     *是否匿名，0:非匿名，1=匿名
     * not null default = 0
     */
    private Integer isAnonymity;

    /**
     *
     *评价状态 0:初始值 1:代理人同意展示 2:代理人拒绝展示
     * not null default = 0
     */
    private Integer appraiseState;

    /**
     *
     *创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     *
     *更新时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;
}