package cn.com.duiba.kjy.api.remoteservice.company;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.SimpleDto;
import cn.com.duiba.kjy.api.dto.company.CompanyDto;
import cn.com.duiba.kjy.api.dto.company.CompanySimpleDto;
import cn.com.duiba.kjy.api.params.company.CompanyPageQryParams;

import java.util.List;

/**
 * 公司服务
 *
 * @author zhanghuifeng
 * date 2019-04-17-16:41
 */
@AdvancedFeignClient
public interface RemoteCompanyService {

    /**
     * 新增
     *
     * @param dto
     * @return
     */
    Boolean add(CompanyDto dto);

    /**
     * 批次查询
     *
     * @param ids
     * @return
     */
    List<CompanyDto> listByIds(List<Long> ids);

    /**
     * 获取所有
     *
     * @return
     */
    List<SimpleDto> findAll();

    /**
     * 分页查询
     *
     * @param params
     * @return
     */
    List<CompanyDto> findPageList(CompanyPageQryParams params);

    /**
     * 分页查询获取总数
     *
     * @param params
     * @return
     */
    int findPageCount(CompanyPageQryParams params);

    /**
     * 编辑
     *
     * @param dto
     * @return
     */
    Boolean update(CompanyDto dto);

    /**
     * 删除
     *
     * @param id
     * @return
     */
    Boolean deleteById(Long id);


    CompanyDto getById(Long id);


    /**
     * 根据公司名称精确查找，全匹配
     *
     * @param companyName
     * @return
     */
    CompanyDto findByName(String companyName);

    /**
     * 往公司插入文章
     * @param companyIds
     * @param itemId
     * @param itemType
     */
    void batchDirectContentToCompanys(String companyIds, Long itemId, Integer itemType);


    /**
     * 根据公司id 公司等级查询公司id名称列表
     * @param companyLevel
     * @return
     */
    List<CompanyDto> getCompanyByLevel( Integer companyLevel);

    /**
     * 根据公司id查询simpleDto
     * @param companyId
     * @return
     */
    CompanySimpleDto getSimpleDtoById(Long companyId);

    /**
     * 根据公司id，获取该公司所在总公司的行业id
     * @param companyId
     * @return
     */
    Long getParentCompanyTradeIdByCompanyId(Long companyId);
}
