package cn.com.duiba.kjy.api.dto.sourcereload;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 爬虫资源重试表
 * @author kjj mybatis generator 
 * 2020-03-12
 */
@Data
public class SourceReloadDto implements Serializable {
    private static final long serialVersionUID = 15840167035587689L;

    /**
     *
     *主键
     * not null default = null
     */
    private Long id;

    /**
     *
     *资源来源地址
     * max length = 256
     */
    private String refUrl;

    /**
     *
     *资源地址
     * max length = 256
     * not null default = null
     */
    private String sourceUrl;

    /**
     *
     *oss地址
     * max length = 256
     * not null default = null
     */
    private String ossUrl;

    /**
     *
     *重试次数
     */
    private Integer retryNum;

    /**
     *
     *资源类型,1图片，2视频，3音频
     * not null default = null
     */
    private Integer sourceType;
    /**
     * 请求头
     */
    private String headers;

    /**
     *
     *创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     *
     *更新时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;
}