package cn.com.duiba.kjy.api.params.seller;

import org.jetbrains.annotations.NotNull;

import java.io.Serializable;

/**
 * @author zhanghuifeng
 * date 2019-05-23-14:00
 */
public class SellerAccountChangeParams implements Serializable {
    private static final long serialVersionUID = -7003547288913534004L;

    /**
     * 当前账户的销售员ID
     */
    @NotNull
    private Long sellerId;

    /**
     * 变更金额（分）
     */
    @NotNull
    private Integer changeMoney;

    /**
     * 业务类型
     * @see cn.com.duiba.kjy.api.enums.seller.SellerAccountBizTypeEnum
     */
    @NotNull
    private Integer bizType;

    /**
     * 业务ID
     */
    @NotNull
    private String bizId;

    /**
     * 好友/下级ID
     */
    private Long subordinateId;

    /**
     * 账户明细状态
     * @see cn.com.duiba.kjy.api.enums.seller.SellerAccountDetailStateEnum
     */
    @NotNull
    private Integer bizState;

    /**
     * 备注
     */
    private String remark;

    public Long getSellerId() {
        return sellerId;
    }

    public void setSellerId(Long sellerId) {
        this.sellerId = sellerId;
    }

    public Integer getChangeMoney() {
        return changeMoney;
    }

    public void setChangeMoney(Integer changeMoney) {
        this.changeMoney = changeMoney;
    }

    public Integer getBizType() {
        return bizType;
    }

    public void setBizType(Integer bizType) {
        this.bizType = bizType;
    }

    public String getBizId() {
        return bizId;
    }

    public void setBizId(String bizId) {
        this.bizId = bizId;
    }

    public Long getSubordinateId() {
        return subordinateId;
    }

    public void setSubordinateId(Long subordinateId) {
        this.subordinateId = subordinateId;
    }

    public Integer getBizState() {
        return bizState;
    }

    public void setBizState(Integer bizState) {
        this.bizState = bizState;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
}
