package cn.com.duiba.kjy.api.params.seller;

import cn.com.duiba.kjy.api.params.PageQuery;
import lombok.Data;
import lombok.ToString;

import java.util.Date;
import java.util.List;

/**
 * @author lizhi
 * @date 2019/6/27 9:48 AM
 */
@Data
@ToString
public class SellerImportTaskParams extends PageQuery {
    /**
     * 主键
     */
    private Long id;

    /**
     * 销售员ID，对应tb_seller.id
     */
    private Long sellerId;

    /**
     * 原文地址
     */
    private String sourceUrl;

    /**
     * 内容ID，对应tb_content.id
     */
    private Long contentId;

    /**
     * 状态，1=未执行、2=执行中、3=调用失败、4=执行失败、5=执行成功、6=完成
     * @see cn.com.duiba.kjy.api.enums.seller.SellerImportTaskStatusEnum
     */
    private Integer state;

    /**
     * 执行失败的详细错误信息
     */
    private String errMsg;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

    /**
     * 原文地址md5值
     */
    private String sourceUrlCode;

    /**
     * 查询多个状态的数据
     */
    private List<Integer> stateList;

    /**
     * 导入类型
     */
    private Integer importType;
}
