package cn.com.duiba.kjy.api.dto.autoreply;

import lombok.Data;

/**
 * @auther: linjianhui
 * @date: 2020-03-05 16:52
 * @description: 自动回复详细信息
 */
@Data
public class AutoReplyDetailDto extends AutoReplyDto {
    private static final long serialVersionUID = 2736922293360585816L;

    /**
     *
     *1:客服文字消息 2:客服图片消息 6:客服卡片消息，8:小程序卡片，详见MessageTypeEnum
     * not null default = null
     */
    private Integer messageType;

    /**
     *
     *标题
     * max length = 255
     */
    private String title;

    /**
     *
     *描述
     * max length = 255
     */
    private String pushDesc;

    /**
     *
     *缩略图
     * max length = 255
     */
    private String mainImgUrl;

    /**
     *
     *跳转地址
     * max length = 255
     */
    private String jumpPath;

    /**
     *
     *客服文字消息的内容
     * max length = 800
     */
    private String customWords;

    /**
     *
     *图片消息的微信返回的ID
     * max length = 255
     */
    private String picMediaId;

    /**
     *
     *小程序卡片消息的小程序ID
     */
    private Long mpId;
}
