package cn.com.duiba.kjy.api.dto.autoreply;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 自动回复表
 * @author kjj mybatis generator
 * 2020-03-02
 */
@Data
public class AutoReplyDto implements Serializable {
    private static final long serialVersionUID = 15831383264036698L;

    /**
     *
     * tb_auto_reply 主键
     * not null default = null
     */
    private Long id;

    /**
     *
     *回复内容
     * max length = 64
     * not null default = null
     */
    private String replyContent;

    /**
     *
     *1:全部，2:VIP 3:非VIP
     * not null default = null
     */
    private Integer sellerFilterType;

    /**
     *
     *指定推送版本 0:全部 1:通用版,2:保险版
     * not null default = null
     */
    private Integer pushVersion;

    /**
     *
     *生效时间（开始）
     * not null default = null
     */
    private Date effectiveTimeStart;

    /**
     *
     *生效时间（结束）
     * not null default = null
     */
    private Date effectiveTimeEnd;

    /**
     *
     *推送事件，BI统计使用,目前固定为 S310
     * max length = 10
     */
    private String pushEvent;

    /**
     *
     *状态，1=启用、2=未启用
     * not null default = 1
     */
    private Integer state;

    /**
     *
     *是否删除，1=已删除，0=未删除
     * not null default = 0
     */
    private Integer deleted;

    /**
     *
     *备注
     * max length = 255
     */
    private String remarks;

    /**
     *
     *创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     *
     *更新时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;
}
