package cn.com.duiba.kjy.api.enums.preInsatll;

import kotlin.concurrent.LocksKt;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * @author xiaotian
 * @date 2020/1/7 3:43 PM
 */
public enum PreInstallSellerStatusEnum {

    FAILE(2,"激活失败"),
    USE(1, "已激活"),
    NON_USE(0,"待激活"),
    DELETE(-1,"删除"),
    LOCK(3,"被锁定，暂未激活")
    ;

    private Integer code;
    private String desc;

    PreInstallSellerStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getDesc() {
        return desc;
    }

    public Integer getCode() {
        return code;
    }

    private static final Map<Integer, PreInstallSellerStatusEnum> ENUM_MAP = new HashMap<>();

    static{
        for(PreInstallSellerStatusEnum tmp : values()){
            ENUM_MAP.put(tmp.getCode(), tmp);
        }
    }

    public static PreInstallSellerStatusEnum getByCode(Integer code) {
        PreInstallSellerStatusEnum preInstallBatchStatusEnum = ENUM_MAP.get(code);
        if(Objects.isNull(preInstallBatchStatusEnum)){
            return NON_USE;
        }
        return preInstallBatchStatusEnum;
    }

    @Deprecated
    public static Boolean change2NoUse(Integer code) {
        PreInstallSellerStatusEnum preInstallBatchStatusEnum = getByCode(code);
        if(preInstallBatchStatusEnum.equals(PreInstallSellerStatusEnum.NON_USE) || preInstallBatchStatusEnum.equals(PreInstallSellerStatusEnum.DELETE)){
            return true;
        }
        return false;
    }


    /**
     * 是否是可激活状态
     * @param code
     * @return
     */
    public static Boolean canActivate(Integer code) {
        PreInstallSellerStatusEnum preInstallBatchStatusEnum = getByCode(code);
        if(preInstallBatchStatusEnum.equals(PreInstallSellerStatusEnum.NON_USE) || preInstallBatchStatusEnum.equals(PreInstallSellerStatusEnum.FAILE)){
            return true;
        }
        return false;
    }
}
