package cn.com.duiba.kjy.api.params.autoreply;

import cn.com.duiba.kjy.api.params.PageQuery;
import lombok.Data;

import java.util.Date;

/**
 * @auther: linjianhui
 * @date: 2020-03-05 19:42
 * @description: 自动回复搜索参数
 */
@Data
public class AutoReplySearchParams extends PageQuery {

    /**
     *
     *回复内容
     * max length = 64
     * not null default = null
     */
    private String replyContent;

    /**
     *
     *1:全部，2:VIP 3:非VIP
     * not null default = null
     */
    private Integer sellerFilterType;

    /**
     *
     *指定推送版本 0:全部 1:通用版,2:保险版
     * not null default = null
     */
    private Integer pushVersion;

    /**
     *
     *状态，1=启用、2=未启用
     * not null default = 1
     */
    private Integer state;

    /**
     *
     *生效时间（开始）
     * not null default = null
     */
    private Date effectiveTimeStart;

    /**
     *
     *生效时间（结束）
     * not null default = null
     */
    private Date effectiveTimeEnd;

}
