package cn.com.duiba.kjy.api.remoteservice.greeting;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.greeting.VisitorGreetingCardRecordDto;
import cn.com.duiba.kjy.api.params.greeting.GreetingReceiveRedPacketParam;
import cn.com.duiba.kjy.api.params.greeting.ReceiveGiftParam;
import cn.com.duiba.kjy.api.params.greeting.GreetingThanksParam;
import cn.com.duiba.kjy.api.params.greeting.VisitorGreetingCardRecordQueryParam;

import java.util.List;

/**
 * 远程节日贺卡访问记录服务
 * @author 刘超
 * @date 2019/12/18 17:26
 * @version 1.0
 */
@AdvancedFeignClient
public interface RemoteVisitorGreetingCardRecordService {

    /**
     * 根据配置id和访客用户id查询
     * @param confId 配置id
     * @param visitorId 访客用户id
     * @return 用户参与贺卡记录信息
     */
    VisitorGreetingCardRecordDto findByConfIdAndVisitorId(Long confId, Long visitorId);

    /**
     * 分页查询
     * @param queryParam 分页查询条件
     * @return 用户参与贺卡记录信息集合
     */
    List<VisitorGreetingCardRecordDto> findPageList(VisitorGreetingCardRecordQueryParam queryParam);

    /**
     * 保存访问记录
     * 上线之后去掉
     * @param dto 用户参与贺卡记录信息
     * @return 是否成功
     */
    @Deprecated
    boolean save(VisitorGreetingCardRecordDto dto);

    /**
     * 答谢
     * @param confId 活动配置ID，对应tb_seller_greeting_card_conf.id
     * @param visitorId 用户ID(访问者)，对应 tb_users.id
     * @return 是否成功
     */
    boolean thanks(Long confId, Long visitorId);

    /**
     * 答谢
     * @param confId 活动配置ID，对应tb_seller_greeting_card_conf.id
     * @param visitorId 用户ID(访问者)，对应 tb_users.id
     * @param thanksImgUrl 答谢图片
     * @return 是否成功
     */
    boolean thanksByImg(Long confId, Long visitorId, String thanksImgUrl);

    /**
     * 答谢
     * @param thanksParam 答谢参数
     * @return 是否成功
     */
    boolean thanksByParam(GreetingThanksParam thanksParam);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 用户参与贺卡记录
     */
    VisitorGreetingCardRecordDto findById(Long id);

    /**
     * 领取红包
     * @param param 领取红包参数
     * @return 领取状态
     */
    void asyncReceiveRedPacket(GreetingReceiveRedPacketParam param);

    /**
     * 更改为领取中的状态
     * @param id 主键id
     * @param redPacketId 红包id
     * @param receiveAmount 领取金额
     * @param redPacketBlessWord 红包祝福语
     * @return 执行结果
     */
    int updateReceiving(Long id, Long redPacketId, Integer receiveAmount, String redPacketBlessWord);

    /**
     * 获取或保存访问记录
     * @param dto 用户参与贺卡记录信息
     * @return 已存在返回最新的，否则插入之后返回最新信息
     */
    VisitorGreetingCardRecordDto getOrSaveRecord(VisitorGreetingCardRecordDto dto);

    /**
     * 更改领取红包状态
     * @param id 主键
     * @param recordReceiveEnum 领取状态
     * @param expectReceivedStateEnum 预期的领取状态
     * @param failReason 领取失败原因
     * @return 执行结果
     */
    int updateReceived(Long id, Integer recordReceiveEnum, Integer expectReceivedStateEnum, String failReason);

    /**
     * 领取礼物
     * @param param 领取礼物参数
     * @return 是否领取成功
     */
    boolean receiveGift(ReceiveGiftParam param);

    /**
     * 根据id修改
     * @param dto 用户参与贺卡记录信息
     * @return 修改是否成功
     */
    boolean updateById(VisitorGreetingCardRecordDto dto);
}
