package cn.com.duiba.kjy.api.remoteservice.interaction;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.contentinteractionquestion.ContentInteractionQuestionDto;
import cn.com.duiba.kjy.api.dto.interaction.ContentInteractionDetailDto;
import cn.com.duiba.kjy.api.dto.interaction.ContentInteractionDto;
import cn.com.duiba.kjy.api.dto.interaction.InteractionMaterialContentDto;
import cn.com.duiba.kjy.api.params.Page;
import cn.com.duiba.kjy.api.params.interaction.ContentInteractionSearchParams;

import java.util.List;

/**
 * 互动问题
 * @author 吴文哲
 * @date 2019-08-26 18:11
 **/
@AdvancedFeignClient
public interface RemoteContentInteractionService {

    /**
     * 根据内容ID查询
     * @param contentIds 内容ID集合
     * @return 互动列表
     */
    List<ContentInteractionQuestionDto> selectByContentIds(List<Long> contentIds);

    /**
     * 新增或更新
     * @param interactionDto 互动信息
     * @return 互动主键
     */
    Long saveOrUpdate(ContentInteractionDetailDto interactionDto);

    /**
     * 启用或撤回
     * @param id 主键
     * @param state 状态
     * @return 执行结果
     */
    boolean openOrClose(Long id, Integer state);

    /**
     * 分页查询互动
     * @param params 参数
     * @return 分页互动数据
     */
    Page<ContentInteractionDto> selectPage(ContentInteractionSearchParams params);

    /**
     * 根据主键查询互动及互动详情（投票、答题、表格信息）
     * @param id 主键
     * @return 互动详情
     */
    ContentInteractionDetailDto findDetailByIdCache(Long id);

    /**
     * 根据销售员转载ID查询互动及互动详情（投票、答题、表格信息）
     * @param scId 销售员转载内容ID
     * @return 互动详情
     */
    ContentInteractionDetailDto findDetailByScIdCache(Long scId);

    /**
     * 根据内容ID查询内容页配置的互动详情（投票、答题、表格信息）
     * @param contentId 内容ID
     * @return 互动详情
     */
    ContentInteractionDetailDto findContentCustomDetailByContentIdCache(Long contentId);

    /**
     * 根据主键查询互动（不包含详情）
     * @param id 主键
     * @return 互动
     */
    ContentInteractionDto findById(Long id);

    /**
     * 根据销售员转载ID查询互动（不包含详情）
     * @param scId 销售员转载内容ID
     * @return 互动
     */
    ContentInteractionDto findByScId(Long scId);

    /**
     * 根据内容ID，查询文章内配置的互动（不包含详情）
     * @param contentId 内容ID
     * @return 互动
     */
    ContentInteractionDto findContentCustomByContentId(Long contentId);

    /**
     * 新增关系，并增加模板使用次数
     * @param contentId 内容ID
     * @param interactionId 互动ID
     * @param interactionTemplateId 模板ID
     * @return 是否成功
     */
    boolean saveRelationAndIncreaseTemplateUseTimes(Long contentId, Long interactionId, Long interactionTemplateId);

    /**
     * 模板使用次数+1
     * @param interactionTemplateId 模板主键
     * @return 执行结果
     */
    boolean increaseTemplateUseTimes(Long interactionTemplateId);

    /**
     * 增加互动人数
     * @param interactionId 互动ID
     * @param contentId 内容ID
     * @return 是否成功
     */
    boolean increaseInteractionPeople(Long contentId, Long interactionId);

    /**
     * 用户参与互动后置处理（增加投票人数等）
     * @param dto 用户互动信息
     * @param contentId 内容ID
     * @return 执行结果
     */
    boolean participateAfterHandle(InteractionMaterialContentDto dto, Long contentId);

}
