package cn.com.duiba.kjy.api.constant;


import com.google.common.collect.Lists;
import org.apache.commons.lang.StringUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by zhangshun on 2019/2/13.
 */
public enum ContentTypeEnum {

    /**
     * 内容类型
     */
    ARTICLE("article", "文章"),
    ACTIVITY("activity", "活动"),
    DAILY("daily", "早报"),
    POSTER("poster", "海报"),
    AFTERNOON("afternoon", "午后话题"),
    EVENING("evening", "晚安心语"),
    GAME_LOTTERY("game_lottery", "抽奖工具"),
    GAME_TEMPLATE("game_template", "抽奖模板"),
    GAME_ANSWER("game_answer", "趣味测试"),
    GAME_ANIMATION("game_animation", "动画"),
    GREETING_CARD("greeting_card", "节日贺卡"),
    INVITATION_LETTER("invitation_letter", "邀请函"),
    MATERIAL_CONTENT("material_content", "发圈素材"),
    HONORARY_ALBUM("honorary_album", "荣誉相册"),

    // 访问记录的类型
    @Deprecated
    SELLER("seller", "销售员名片"),
    /**
     * 新版名片，不兼容老版。设立新类型
     */
    SELLER_CARD("card", "名片分享"),
    OUTER_MARKET("outer_market", "腰封自定义链接"),
    OUTER_EXCLUSIVE("outer_exclusive", "专区自定义链接"),
    WEEKLY_PUBLICATION("weekly_publication", "代理人周报"),
    NETWORK_LINK("network_link", "全网链接"),
    VIDEO("video", "视频"),
    ;

    private String code;
    private String desc;

    ContentTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    private static final Map<String, ContentTypeEnum> ENUM_MAP = new HashMap<>();

    static {
        for (ContentTypeEnum type : values()) {
            ENUM_MAP.put(type.getCode(), type);
        }
    }

    public static ContentTypeEnum getByCode(String code) {
        ContentTypeEnum result = ENUM_MAP.get(code);
        if (result == null) {
            return null;
        }
        return result;
    }

    public static boolean isContent(String type) {
        return StringUtils.equals(type, ARTICLE.code) ||
                StringUtils.equals(type, ACTIVITY.code) ||
                StringUtils.equals(type, DAILY.code) ||
                StringUtils.equals(type, POSTER.code) ||
                StringUtils.equals(type, AFTERNOON.code) ||
                StringUtils.equals(type, EVENING.code) ||
                StringUtils.equals(type, GAME_LOTTERY.code) ||
                StringUtils.equals(type, GAME_TEMPLATE.code) ||
                StringUtils.equals(type, GAME_ANIMATION.code) ||
                StringUtils.equals(type, GAME_ANSWER.code) ||
                StringUtils.equals(type, GREETING_CARD.code) ||
                StringUtils.equals(type, VIDEO.code)||
                StringUtils.equals(type,MATERIAL_CONTENT.code)
                ;
    }

    public static boolean isNeedAnalyse(String type) {
        return StringUtils.equals(type, ARTICLE.code) ||
                StringUtils.equals(type, ACTIVITY.code) ||
                StringUtils.equals(type, DAILY.code) ||
                StringUtils.equals(type, EVENING.code) ||
                StringUtils.equals(type, OUTER_EXCLUSIVE.code) ||
                StringUtils.equals(type, OUTER_MARKET.code) ||
                StringUtils.equals(type, GAME_LOTTERY.code) ||
                StringUtils.equals(type, GAME_TEMPLATE.code) ||
                StringUtils.equals(type, GAME_ANIMATION.code) ||
                StringUtils.equals(type, GAME_ANSWER.code) ||
                StringUtils.equals(type, NETWORK_LINK.code)
                ;
    }

    public static boolean isPaper(String type) {
        return StringUtils.equals(type, DAILY.code) ||
                StringUtils.equals(type, AFTERNOON.code) ||
                StringUtils.equals(type, EVENING.code)
                ;
    }

    /**
     * 获取不需要统计的内容类型
     *
     * @return
     */
    public static List<String> getUnNeedAnalyseTypes() {
        List<String> resultList = new ArrayList<>();
        resultList.add(ContentTypeEnum.POSTER.getCode());
        resultList.add(ContentTypeEnum.SELLER_CARD.getCode());
        return resultList;
    }

    public static boolean isMarket(String type) {
        return StringUtils.equals(type, OUTER_MARKET.code);
    }

    public static boolean isSellerCard(String type) {
        return StringUtils.equals(type, SELLER_CARD.code);
    }

    public static boolean isExclusive(String type) {
        return StringUtils.equals(type, OUTER_EXCLUSIVE.code);
    }

    public static boolean isSeller(String type) {
        return StringUtils.equals(type, SELLER.code);
    }

    public static boolean isActivity(String type) {
        return StringUtils.equals(type, ACTIVITY.code) ||
                isGameActivity(type)
                ;
    }

    public static boolean isGameActivity(String type) {
        return isGameH5Activity(type) ||
                StringUtils.equals(type, GAME_TEMPLATE.code);
    }

    public static boolean isGameH5Activity(String type) {
        return StringUtils.equals(type, GAME_LOTTERY.code) ||
                StringUtils.equals(type, GAME_ANSWER.code) ||
                StringUtils.equals(type, GAME_ANIMATION.code);
    }

    public static List<String> getGameActivityContentTypes() {
        List<String> list = new ArrayList<>();
        for (ContentTypeEnum typeEnum : values()) {
            if (isGameH5Activity(typeEnum.code)) {
                list.add(typeEnum.code);
            }
        }
        return list;
    }

    /**
     * 新手任务 是否为文章类型 包括文章 早报 晚报
     * @param type
     * @return
     */
    public static boolean isNoviceTaskArticleType(String type) {
        return StringUtils.equals(type, ARTICLE.code)
                || StringUtils.equals(type, DAILY.code)
                || StringUtils.equals(type, EVENING.code);
    }

    /**
     * 新手任务 是否为动画类型
     * @param type
     * @return
     */
    public static boolean isNoviceTaskActivityType(String type) {
        return StringUtils.equals(type, ACTIVITY.code);
    }

    /**
     * 是否为全网链接
     * @param type
     * @return
     */
    public static boolean isNetworkLink(String type) {
        return StringUtils.equals(type, NETWORK_LINK.code);
    }

    /**
     * 需要访问分析的内容
     * @param type
     * @return
     */
    public static boolean isClueContentType(String type) {
        return StringUtils.equals(type, ARTICLE.code) || StringUtils.equals(type, ACTIVITY.code)
                || StringUtils.equals(type, DAILY.code) || StringUtils.equals(type, EVENING.code)
                || StringUtils.equals(type, GAME_ANSWER.code) || StringUtils.equals(type, GAME_ANIMATION.code);
    }

    /**
     * 判断是否是代理人访问动态
     * @param type
     * @return
     */
    public static boolean isSellerVisitDynamicType(String type){
        List<String> list = Lists.newArrayList(ARTICLE.code,DAILY.code,GAME_ANIMATION.code,EVENING.code);
        return list.contains(type);
    }

    /**
     * 判断是否是代理人转发素材动态
     * @param type
     * @return
     */
    public static boolean isSellerForwardMaterialDynamicType(String type){
        List<String> list = Lists.newArrayList(ARTICLE.code,GAME_ANIMATION.code,GAME_ANSWER.code,POSTER.code,VIDEO.code);
        return list.contains(type);
    }

    /**
     * 判断是否是代理人转发名片动态
     * @param type
     * @return
     */
    public static boolean isSellerForwardCardDynamicType(String type){
        List<String> list = Lists.newArrayList(SELLER_CARD.code);
        return list.contains(type);
    }

    /**
     * 判断是否是代理人使用营销工具动态
     * @param type
     * @return
     */
    public static boolean isSellerUseMarketingToolDynamicType(String type){
        List<String> list = Lists.newArrayList(INVITATION_LETTER.code,GREETING_CARD.code,GAME_TEMPLATE.code);
        return list.contains(type);
    }

}
