package cn.com.duiba.kjy.api.enums.seller;

import java.util.Objects;

/**
 * @author wangbinbin
 * @create 2020-01-11 11:54
 * @descript 客户是否在线枚举
 */
public enum SellerCustomerIsOnlineEnum {

    IS_ONLINE(1, "在线"),
    NOT_ONLINE(0, "离线");

    private Integer code;
    private String description;

    SellerCustomerIsOnlineEnum(Integer code, String description) {
        this.code = code;
        this.description = description;
    }

    public Integer getCode() {
        return code;
    }

    public String getDescription() {
        return description;
    }

    /**
     * 根据代码值获取code
     * @param code
     * @return
     */
    public static SellerCustomerIsOnlineEnum getByCode(Integer code) {
        for (SellerCustomerIsOnlineEnum sellerCustomerIsOnlineEnum : SellerCustomerIsOnlineEnum.values()) {
            if (Objects.equals(sellerCustomerIsOnlineEnum.getCode(), code)) {
                return sellerCustomerIsOnlineEnum;
            }
        }
        return null;
    }

}
