package cn.com.duiba.kjy.api.enums.user;

import cn.com.duiba.kjy.api.enums.seller.SellerVipTypeEnum;

/**
 * 最后一次客服消息推送状态
 * @author zhanghuifeng
 * date 2019/12/17-1:51 下午
 */
public enum LastPushStateEnum {

    FAILED(0, "失败"),
    SUCCEED(1, "成功"),
    ;

    private Integer code;

    private String desc;

    LastPushStateEnum(Integer code, String desc){
        this.code = code;
        this.desc = desc;
    }

    /**
     * x
     * @param code
     * @return
     */
    public static SellerVipTypeEnum getByCode(Integer code) {
        for (SellerVipTypeEnum enumVal : SellerVipTypeEnum.values()) {
            if (enumVal.getCode().equals(code)) {
                return enumVal;
            }
        }
        return null;
    }

    public static String getDescByCode(Integer code) {
        for (SellerVipTypeEnum enumVal : SellerVipTypeEnum.values()) {
            if (enumVal.getCode().equals(code)) {
                return enumVal.getDesc();
            }
        }
        return "";
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
