package cn.com.duiba.kjy.api.enums.push;

/**
 * @author wangbinbin
 * @create 2019-11-06 09:43
 * @descript 对应tb_push_manager中的scene字段
 */
public enum PushManagerSceneEnum {
    /**
     * 运营自定义的临时、热点内容（文章，活动，动画）推送。
     * 推送内容为卡片，降级模版
     */
    ANIMATION_PUSH(1, "内容推送"),
    /**
     * 原来的自定义推送是指自定义推送文章，活动等现在把它和自定义动画推送合并在一起
     * 把2和1规整在一起了。code = 2 废弃！！！
     */
    @Deprecated
    CUSTOMER_PUSH(2, "自定义推送"),

    /**
     * 和内容（文章，活动，动画）无关，消息内容自定义
     */
    CUSTOMER_PUSH_NEW(3,"自定义推送")
    ;


    private Integer code;
    private String description;

    PushManagerSceneEnum(Integer code, String description) {
        this.code = code;
        this.description = description;
    }

    public Integer getCode() {
        return code;
    }

    public String getDescription() {
        return description;
    }

}
