package cn.com.duiba.kjy.api.params.animation;

import cn.com.duiba.kjy.api.params.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;


/**
 * @author lizhi
 * @date 2019/8/23 6:37 PM
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class AnimationParams extends PageQuery {

    private static final long serialVersionUID = -4435360749643412851L;

    /**
     * appId， 预览和正式通过改ID关联
     */
    private Long appId;

    /**
     * 动画名称
     */
    private String animationName;

    /**
     * 动画插件，由前端定义值
     */
    private String plugins;

    /**
     * 动画类型，0-预览，1-正式
     */
    private Integer animationType;

    /**
     * 业务类型，1001-热门动画，1101-邀请函（海报），1102-邀请函（动画）
     * @see cn.com.duiba.kjy.api.enums.animation.AnimationBizTypeEnum
     */
    private Integer bizType;
}
