package cn.com.duiba.kjy.api.remoteservice.home;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.home.SubscriptionDto;
import cn.com.duiba.kjy.api.dto.home.SubscriptionSimpleDto;
import cn.com.duiba.kjy.api.params.home.SubscriptionParam;
import cn.com.duiba.kjy.api.params.home.SubscriptionSearchParam;

import java.util.List;

/**
 * @author wangbinbin
 * @create 2020-03-25 14:42
 * @descript 首页频道页remoteService
 */
@AdvancedFeignClient
public interface RemoteSubscriptionService {

    /**
     * 新增公众号
     * @param subscriptionDto
     * @return
     */
    boolean save(SubscriptionDto subscriptionDto);

    /**
     * 更新公众号
     * @param subscriptionDto
     * @return
     */
    boolean updateById(SubscriptionDto subscriptionDto);

    /**
     * 列表查询
     * @param subscriptionParam
     * @return
     */
    List<SubscriptionDto> listByParam(SubscriptionParam subscriptionParam);

    /**
     * 总数查询
     * @param subscriptionParam
     * @return
     */
    int countByParam(SubscriptionParam subscriptionParam);

    /**
     * 根据条件查询公众号列表
     * @param params
     * @return
     */
    List<SubscriptionDto> selectList(SubscriptionSearchParam params);

    /**
     * 根据主键删除id
     * @param id
     * @return
     */
    boolean deleteById(Long id);

    /**
     * 根据id获取详情
     * @param id
     * @return
     */
    SubscriptionDto getById(Long id);

    /**
     * 通过id列表批量查询
     * @param ids
     * @return
     */
    List<SubscriptionDto> findByIds(List<Long> ids);

    /**
     * 查询所有公众号id和name
     * @return
     */
    List<SubscriptionSimpleDto> listAll();

    /**
     * 根据grabWebIds查询已添加的公众号
     * @param grabWebIds
     * @return
     */
    List<Long> listExistByGrabWebId(List<Long> grabWebIds);

    /**
     * 获取公众号标签id列表
     * @return
     */
    List<Long> findTagIds();

    /**
     * 代理人查看公众号详情标记
     * @param sellerId
     * @param subId
     * @return
     */
    Boolean clickSubscription(Long sellerId,Long subId);

}
