package cn.com.duiba.kjy.api.dto.process;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 审核角色表
 * @author kjj mybatis generator 
 * 2020-04-30
 */
@Data
public class ProcessRoleDto implements Serializable {
    private static final long serialVersionUID = 15882136949329234L;

    private Long id;

    /**
     *
     *角色类型 1:销售主管 2:财务
     */
    private Long roleType;

    /**
     *
     *角色ID类型 1:内部销售ID 2:sso账号ID
     * not null default = null
     */
    private Integer roleIdType;

    /**
     *
     *对应的角色ID
     * not null default = null
     */
    private Long roleBizId;

    /**
     *
     *对应的角色名称
     * max length = 45
     * not null default = null
     */
    private String roleBizName;

    /**
     *
     *状态 1:启用 0:未启用
     * not null default = 1
     */
    private Integer roleBizStatus;

    /**
     *
     *创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     *
     *更新时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;
}