package cn.com.duiba.kjy.api.enums.push;


/**
 * @author linjianhui
 * @description 推送内容状态
 * @date 2020-01-08 19:41
 */
public enum PushContentStateEnum {

    /**
     * 状态：1：等待推送，2：推送成功，3:推送失败
     */
    WAIT(1, "等待推送"),
    SUCCESS(2, "推送成功"),
    FAIL(3, "推送失败"),
    ;
    private Integer code;

    private String desc;

    PushContentStateEnum(int code, String desc){
        this.code = code;
        this.desc = desc;
    }

    public static PushContentStateEnum getByCode(Integer code) {
        for (PushContentStateEnum enumVal : PushContentStateEnum.values()) {
            if (enumVal.getCode()==code) {
                return enumVal;
            }
        }
        return null;
    }

    public int getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
