package cn.com.duiba.kjy.api.params.grassContent;

import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 种草素材编辑参数
 *
 * @author 吴文哲
 * @date 2020-05-13 10:23
 **/
@Data
public class GrassContentEditParam implements Serializable {
    private static final long serialVersionUID = 3959480195139684409L;


    /**
     * 素材id
     */
    private Long contentId;

    /**
     * 素材类型
     * @see cn.com.duiba.kjy.api.enums.accurate.AccurateContentTypeEnum
     */
    private Integer accurateContentType;

    /**
     * 标签id列表   格式例如:		[123, 234, 345]
     * 一级标签在第一位，二级标签其次，三级标签最后
     */
    private List<List<Long>> tagList;

    /**
     * 区分是分类  保险意识/保险产品/增员专区
     */
    @NotNull
    private Long firstTagId;

    /**
     * 文章内标签，最多三个标签，每个标签不超过6个字，标签之间用英文逗号隔开
     * max length = 255
     * not null default =
     */
    private String tags;

    /**
     * 推荐理由
     * max length = 255
     * not null default =
     */
    private String recommendReason;

    /**
     * 问答id列表
     */
    private List<Long> qaIds;

    /**
     * 险种属性标签id，对应tb_accurate_tag的主键id
     */
    private Long insurancePropertyTag;


    /**
     * 是否热榜文章 如果true就需要同步到热榜
     */
    private Boolean isHotContent;

    /**
     * 数据标签
     */
    private String dataTag;


    /***********------保险产品需要的属性------**************/

    /**
     * 公司id
     */
    private Long companyId;


    /**
     * 产品id
     */
    private Long productId;

    /**
     * 私信小科普的id
     */
    private Long knowledgeId;

}
