package cn.com.duiba.kjy.api.dto.sellerfollowrecord;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 销售客户跟进记录
 * @author kjj mybatis generator 
 * 2020-04-24
 */
@Data
public class SellerFollowRecordDto implements Serializable {
    private static final long serialVersionUID = 15876947816111178L;

    /**
     *
     *主键
     * not null default = null
     */
    private Long id;

    /**
     *
     *销售id 对应tb_seller.id
     * not null default = null
     */
    private Long sellerId;

    /**
     *
     *用户ID，对应tb_users.id
     * not null default = null
     */
    private Long userId;

    /**
     *
     *是否删除，1=已删除，0=未删除
     * not null default = 0
     */
    private Integer deleted;

    /**
     *
     *跟进信息
     * max length = 125
     */
    private String followInfo;

    /**
     *
     *创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     *
     *更新时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;

}