package cn.com.duiba.kjy.api.enums.seller;

import java.util.Objects;

/**
 * @author wangbinbin
 * @create 2020-05-19 11:17
 * @descript 跟进记录类型枚举
 */
public enum SellerFollowTypeEnum {
    NORMAL(1, "普通跟进"),
    INVITE_ACTIVITY(2, "邀约活动"),
    BIRTH_REMIND(3, "生日提醒"),
    FESTIVAL_REMIND(4, "节日提醒"),
    CUSTOMIZE_REMIND(5, "自定义提醒"),
    ;


    private Integer code;
    private String description;

    SellerFollowTypeEnum(Integer code, String description) {
        this.code = code;
        this.description = description;
    }

    public Integer getCode() {
        return code;
    }

    public String getDescription() {
        return description;
    }

    /**
     * 是否为跟进时间必填的跟进类型
     * @param code
     * @return
     */
    public static boolean isMustNeedFollowTime(Integer code) {
        return Objects.equals(code, INVITE_ACTIVITY.code) || Objects.equals(code, BIRTH_REMIND.code);
    }

    /**
     * 根据代码获取枚举
     * @param code
     * @return
     */
    public static SellerFollowTypeEnum getByCode(Integer code) {
        for (SellerFollowTypeEnum sellerFollowTypeEnum : SellerFollowTypeEnum.values()) {
            if (Objects.equals(sellerFollowTypeEnum.getCode(), code)) {
                return sellerFollowTypeEnum;
            }
        }
        return null;
    }
}
