package cn.com.duiba.kjy.api.remoteservice.explosioncontent;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.explosioncontent.ExplosionContentHeadwordDto;
import cn.com.duiba.kjy.api.params.Page;
import cn.com.duiba.kjy.api.params.explosionContent.HeadwordAddParam;
import cn.com.duiba.kjy.api.params.explosionContent.HeadwordSearchParam;

import java.util.List;

/**
 * @author wangbinbin
 * @create 2020-05-21 10:18
 * @descript 种草素材词条remoteService
 */
@AdvancedFeignClient
public interface RemoteExplosionContentHeadwordService {

    /**
     * 根据主键查询(包含查询已删除的)
     * @param id
     * @return
     */
    ExplosionContentHeadwordDto selectById(Long id);

    /**
     * 根据ids查询列表(包含查询已删除的)
     * @param ids
     * @return
     */
    List<ExplosionContentHeadwordDto> listByIds(List<Long> ids);

    /**
     * 添加/编辑词条
     * @param params
     * @return
     */
    Long addOrUpdate(HeadwordAddParam params);

    /**
     * 根据参数查询词条
     * @param param
     * @return
     */
    Page<ExplosionContentHeadwordDto> searchList(HeadwordSearchParam param);

    /**
     * 删除词条
     * @param id
     * @return
     */
    boolean deleteById(Long id);

}
