package cn.com.duiba.kjy.api.remoteservice.seller;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * 销售关闭不展示的公司行业案例管理
 * @Author chentiecheng
 * @Date 2020/5/9 4:10 下午
 */
@AdvancedFeignClient
public interface RemoteSellerUnShownCaseService {
    /**
     * 根据销售id获取该销售关闭不展示的案例id列表
     * @param sellerId
     * @return
     */
    List<Long> selectUnShownCaseIdList(Long sellerId);

    /**
     * 更新案例模板展示状态
     * @param sellerId
     * @param caseId
     * @param isShow 展示状态，true展示，false不展示
     * @return
     */
    Boolean updateCaseTemplateShowStatus(Long sellerId,Long caseId,Boolean isShow);

    /**
     * 根据模版案例id删除记录
     * @param caseId
     * @return
     */
    Boolean deleteByCaseTemplateId(Long caseId);
}
