package cn.com.duiba.kjy.api.dto.interaction;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 内容和互动关系表
 * @author lizhi
 * @date 2019-09-19
 */
@Data
public class ContentInteractionRelationDto implements Serializable {

    private static final long serialVersionUID = 1568871511162666L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 内容ID，对应tb_content.id
     */
    private Long contentId;

    /**
     * 互动ID，对应tb_content_interaction_question.id
     */
    private Long interactionId;

    /**
     * 互动ID，对应互动模板ID，对应tb_content_interaction_template.id
     */
    private Long interactionTemplateId;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;
}