package cn.com.duiba.kjy.api.dto.sellercardv5;

import lombok.Data;

import java.io.Serializable;

/**
 * 名片详情页顶部
 * @author 吴文哲
 * @date 2020-03-16 16:58
 **/
@Data
public class SellerCardTopOfDetailDto implements Serializable {
    private static final long serialVersionUID = 8507504926317405483L;


    /**
     * 名片加密的scid
     */
    private Long scid;

    /**
     * 代理人id
     */
    private Long sellerId;

    /**
     * 销售自定头像
     */
    private String avatar;

    /**
     * 名片专业风格头像
     */
    private String professionalAvatar;

    /**
     *  大图风格 头像
     */
    private String backgroundAvatar;

    /**
     * 销售员昵称
     */
    private String sellerName;


    /**
     * 销售员职位
     */
    private String jobPost;

    /**
     * 销售员手机号
     */
    private String phoneNumber;

    /**
     * 销售员微信号
     */
    private String wechatNumber;

    /**
     * 微信二维码
     */
    private String wechatQrCode;

    /**
     * 名片地址
     */
    private String address;

    /**
     * 地址定位信息 用于前端反序列化
     */
    private String addressLocation;


    /**
     * 风格切换 1:经典风格/默认风格 2:大图风格 3:专业风格
     */
    private Byte avatarStyle;


    /**
     * 公司Id
     */
    private Long companyId;

    /**
     * 公司名称
     */
    private String companyName;

    /**
     * 总公司名称
     */
    private String parentCompanyName;

    /**
     * 公司logo图片地址
     */
    private String companyLogo;

    /**
     * 代理人名片版本
     */
    private Integer userVersion;


    /**
     * 是否为Vip
     */
    private boolean isVip;
}
