package cn.com.duiba.kjy.api.remoteservice.content;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.push.PushContentDto;
import cn.com.duiba.kjy.api.params.Page;
import cn.com.duiba.kjy.api.params.push.PushContentSearchParams;

import java.util.Date;

/**
 * @auther: linjianhui
 * @date: 2020-01-07 11:05
 * @description: 午间推送内容管理
 */
@AdvancedFeignClient
public interface RemotePushContentService {

    /**
     * 分页查询午间推送内容
     * @param params
     * @return
     */
    Page<PushContentDto> selectPageList(PushContentSearchParams params);

    /**
     * 插入或变更午间推送内容
     * @param dto
     * @return
     */
    Long insertOrUpdate(PushContentDto dto);

    /**
     * 根据id删除午间推送内容
     * @param id
     * @return
     */
    Integer deleteById(Long id);

    /**
     * 查询该日期的有效推送配置
     * @param releaseTime
     * @return
     */
    Long selectOneByDate(Date releaseTime);

}
