package cn.com.duiba.kjy.api.remoteservice.version;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.constant.KjyCenterException;
import cn.com.duiba.kjy.api.dto.user.UserVersionDto;

import java.util.List;

/**
 * 用户版本rpc接口
 * @author 吴文哲
 * @date 2020-02-06 09:32
 **/
@AdvancedFeignClient
public interface RemoteUserVersionService {

    /**
     * 根据用户userid 或 sellerId
     * 获取当前用户正在使用的版本
     * @param userId
     * @param sellerId
     * @return
     */
    UserVersionDto getUserInUseVersionByUserIdOrSellerId(Long userId, Long sellerId);

    /**
     * 根据userId 查询用户版本列表
     * @param userId
     * @return
     */
    List<UserVersionDto> getUserVersionsByUserId(Long userId);

    /**
     * 根据代理人id 查询用户版本列表
     * @param sellerId
     * @return
     */
    List<UserVersionDto> getUserVersionsBySellerId(Long sellerId);

    /**
     * 根据userids 或 sellerIds 获取用户版本信息
     * 如果两个参数都传 以userid优先
     * @param userIds
     * @param sellerIds
     * @return
     */
    List<UserVersionDto> getUserVersionByUserIdsOrSellerIds(List<Long> userIds, List<Long> sellerIds);

    /**
     * 更新代理人版本
     * @param userId  用户id
     * @param targetUserVersion 目标用户版本
     * @param operatorType 操作员类型
     * @return
     */
    Integer exchangeUserVersion(Long userId, Integer targetUserVersion, Integer operatorType) throws KjyCenterException;

    /**
     * 根据userId和版本获取 用户版本信息
     * @param userId
     * @param userVersion
     * @return
     */
    UserVersionDto getUserVersionByUserIdAndVersion(Long userId,Integer userVersion);

    /**
     * 根据userId 清空当前用户所有版本的vip时间
     * @param userId
     * @return
     */
    Integer clearUserVersionVipTimeByUserId(Long userId);

    /**
     * 根据userId  关闭当前用户所有用户版本的启用状态
     * @param userId
     * @return
     */
    Integer closeUserVersionOpenTypeByUserId(Long userId);

    /**
     * 新增用户版本
     * @param userVersionDto
     * @return
     */
    Integer addUserVersion(UserVersionDto userVersionDto);

    /**
     * 更新用户版本
     * @param userVersionDto
     * @return
     */
    Integer updateUserVersion(UserVersionDto userVersionDto);

    /**
     * 根据userId 删除用户版本信息数据
     * @param userIds
     * @return
     */
    Integer deleteByUserIds(List<Long> userIds);
}
