package cn.com.duiba.kjy.api.mqmsg;

import lombok.Data;
import lombok.ToString;

import java.io.Serializable;
import java.util.List;

/**
 * 不活跃代理人通知消息
 * Created by zzy on  2019/06/20 23:16
 */
@Data
@ToString
public class InactiveSellerPushMsg implements Serializable {

    private static final long serialVersionUID = 3773810421838702924L;

    /**
     * 2天不活跃
     */
    public static final int TYPE_2 = 2;
    /**
     * 3天不活跃
     */
    public static final int TYPE_3 = 3;
    /**
     * 5天不活跃
     */
    public static final int TYPE_5 = 5;
    /**
     * 不活跃类型
     */
    private int type;
    /**
     * 接收者openId
     */
    private List<User4Message> users;

    /**
     * 推荐的热文id
     */
    private Long contentId;

    /**
     * 推荐的热文标题
     */
    private String title;

    /**
     * 推荐的热文分享图标
     */
    private String shareImg;
}
