package cn.com.duiba.kjy.api.params.sellercard;

import lombok.Data;

import java.io.Serializable;

/**
 * Created by dugq on 2019-07-30.
 */
@Data
public class SellerCardParam implements Serializable {
    private static final long serialVersionUID = 6225195367961612155L;

    private Long sellerId;
    private Long userId;


    /**
     * 销售自定头像
     */
    private String avatar;

    /**
     *
     *头像区域风格 1:默认 2:专业大屏照
     */
    private Byte avatarStyle;

    /**
     *
     *背景色 1:默认 2:商务专业
     */
    private Byte backgroundStyle;

    /**
     * 销售员昵称 中文名称
     */
    private String sellerName;

    /**
     * 公司Id
     */
    private Long companyId;

    /**
     * 公司名称
     */
    private String companyName;

    /**
     * 销售员职位
     */
    private String jobPost;

    /**
     * 从业时长
     */
    private Integer exprLength;

    /**
     * 自我介绍
     */
    private String personalIntro;

    /**
     * 性别
     */
    private Integer gender;

    /**
     * 生日
     */
    private String birth;

    /**
     * 省市
     */
    private String city;

    /**
     * 家乡/精确到省
     */
    private String hometown;

    /**
     * 毕业院校
     */
    private String school;

    /**
     * 兴趣爱好
     */
    private String hobby;

    /**
     * 销售员手机号
     */
    private String phoneNumber;

    /**
     * 微信号
     */
    private String wechatNumber;

    /**
     * 销售员微信二维码
     */
    private String wechatQrCode;

    /**
     *
     *擅长专业
     */
    private String goodAtMajor;

    /**
     * 封面图片地址
     */
    private String cover;

    /**
     * 是否为自定义公司
     */
    private Integer isCustomCompany;

    /**
     *
     *名片背景图
     */
    private String backgroundAvatar;


    /**
     * 名片背景图 缩略图
     * tb_seller_config 表中 config_key:bg_avatar_tnl
     */
    private String backgroundAvatarThumbnail;

    /**
     * 名片专业风格头像
     */
    private String professionalAvatar;

    /**
     * 专业风格头像缩略图
     * tb_seller_config 表中 config_key:card_professional_avatar_tnl
     */
    private String professionalAvatarThumbnail;


    /**
     * 名片地址
     */
    private String address;

    /**
     * 地址定位信息 用于前端反序列化
     */
    private String addressLocation;


    /**
     * 常规头像
     * tb_seller_config 表中 config_key:card_normal_avatar
     */
    private String normalAvatar;

    /**
     * 常规头像缩略图
     * tb_seller_config 表中 config_key:normal_avatar_tnl
     */
    private String normalAvatarThumbnail;



}
