package cn.com.duiba.kjy.api.dto.honorary;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 荣誉相册扩展信息表
 * @author kjj mybatis generator
 * 2020-02-18
 */
@Data
public class HonoraryAlbumExtDto implements Serializable {

    private static final long serialVersionUID = 4882819018034535469L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 内容ID（邀请函）
     */
    private Long contentId;

    /**
     * 邀请函内容oss地址
     */
    private String honoraryUrl;

    /**
     * 首页大图
     */
    private String homeImageUrl;

    /**
     * 动画工具appId
     */
    private Long animationAppId;

    /**
     * 1-海报，2-动画
     * @see cn.com.duiba.kjy.api.enums.honorary.HonoraryTypeEnum
     */
    private Integer honoraryType;

    /**
     * 分享标题
     */
    private String shareTitle;

    /**
     * 分享描述
     */
    private String shareDesc;

    /**
     * 分享图片
     */
    private String sharePicUrl;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}
