package cn.com.duiba.kjy.api.dto.privatechat;

import java.io.Serializable;
import java.util.Date;

import cn.com.duiba.kjy.api.enums.privatechat.HasUsedEnum;
import cn.com.duiba.kjy.api.enums.privatechat.TriggerEventEnum;
import lombok.Data;

/**
 * 小程序模版消息下发条件表
 * @author kjj mybatis generator 
 * 2019-08-21
 */
@Data
public class UserFormIdDto implements Serializable {
    private static final long serialVersionUID = 15663858482064265L;

    /**
     *
     *主键
     */
    private Long id;

    /**
     *
     *文章销售id
     */
    private Long sellerId;

    /**
     *
     *访客用户id
     */
    private Long userId;

    /**
     *
     *表单提交场景下，为formId
     */
    private String formId;

    /**
     *
     *触发事件，1=点击弹层上的关闭按钮、2=点击弹层上的聊天按钮、3=点击头像
     */
    private TriggerEventEnum triggerEvent;

    /**
     *
     *是否使用 0：未使用 1：已使用
     */
    private HasUsedEnum hasUsed;

    /**
     *
     *过期时间
     */
    private Date expiredTime;

    /**
     * formId来源小程序在tb_office_accounts的id
     */
    private Long oaId;

    /**
     *
     *创建时间
     */
    private Date gmtCreate;

    /**
     *
     *更新时间
     */
    private Date gmtModified;
}