package cn.com.duiba.kjy.api.remoteservice.grabmaterial;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.grabmaterial.MaterialTagDto;
import cn.com.duiba.kjy.api.dto.grabmaterial.MaterialTagListDto;
import cn.com.duiba.kjy.api.params.grabmaterial.MaterialTagListParam;

import java.util.List;

/**
 * 发圈素材标签
 *
 * @Author chentiecheng
 * @Date 2020/3/9 3:45 下午
 */
@AdvancedFeignClient
public interface RemoteMaterialTagService {

    /**
     * 删除标签
     * @param id
     * @return
     */
    Boolean deleteTag(Long id);

    /**
     * 新增更新标签
     * @param dto
     * @return
     */
    Boolean insertOrUpdateTag(MaterialTagDto dto);

    /**
     * 获取素材标签列表
     * @param param
     * @return
     */
    List<MaterialTagListDto> selectList(MaterialTagListParam param);

    /**
     * 查询总数
     * @param dto
     * @return
     */
    Long selectCount(MaterialTagDto dto);

    /**
     * 根据id获取详情
     * @param id
     * @return
     */
    MaterialTagDto getInfoById(Long id);
}
