/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.api.enums.grasscontent;

import cn.com.duiba.kjy.api.util.NumberUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public enum GrassContentPushSceneEnum {
    DAILY_PUSH("daily_push", 1, "\u79cd\u8349\u7d20\u6750\u65e9\u62a5\u63a8\u9001"),
    NOON_PUSH("noon_push", 2, "\u79cd\u8349\u7d20\u6750\u5348\u95f4\u63a8\u9001");

    private String code;
    private Integer slot;
    private String desc;

    private GrassContentPushSceneEnum(String code, Integer slot, String desc) {
        this.code = code;
        this.slot = slot;
        this.desc = desc;
    }

    public static GrassContentPushSceneEnum getByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        for (GrassContentPushSceneEnum enums : GrassContentPushSceneEnum.values()) {
            if (!StringUtils.equals((CharSequence)enums.getCode(), (CharSequence)code)) continue;
            return enums;
        }
        return null;
    }

    public static List<String> getCodeListBySwitches(Integer switches) {
        if (NumberUtil.isNullOrLteZero(switches)) {
            return Collections.emptyList();
        }
        ArrayList<String> results = new ArrayList<String>();
        for (GrassContentPushSceneEnum enums : GrassContentPushSceneEnum.values()) {
            if ((long)(switches & 1 << enums.getSlot() - 1) <= 0L) continue;
            results.add(enums.code);
        }
        return results;
    }

    public static Integer getSwitchesByCodes(List<String> codes) {
        if (CollectionUtils.isEmpty(codes)) {
            return 0;
        }
        Integer switches = 0;
        for (GrassContentPushSceneEnum enums : GrassContentPushSceneEnum.values()) {
            if (!codes.contains(enums.getCode())) continue;
            switches = switches | 1 << enums.getSlot() - 1;
        }
        return switches;
    }

    public String getCode() {
        return this.code;
    }

    public Integer getSlot() {
        return this.slot;
    }

    public String getDesc() {
        return this.desc;
    }

    public static List<Integer> getQueryResult(Integer slot) {
        LinkedList<Integer> resultList = new LinkedList<Integer>();
        int total = 2 << GrassContentPushSceneEnum.values().length - 1;
        for (int i = 0; i < total; ++i) {
            String binaryStr = GrassContentPushSceneEnum.decimal2Binary(i, GrassContentPushSceneEnum.values().length);
            if (!Objects.equals(binaryStr.substring(slot - 1, slot), "1")) continue;
            resultList.add(Integer.valueOf(binaryStr, 2));
        }
        return resultList;
    }

    public static String decimal2Binary(int decNum, int digit) {
        String binStr = "";
        for (int i = digit - 1; i >= 0; --i) {
            binStr = binStr + (decNum >> i & 1);
        }
        return binStr;
    }
}

