package cn.com.duiba.kjy.api.dto.grabmaterial;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 爬虫素材库
 * @author kjj mybatis generator
 * 2020-03-05
 */
@Data
public class GrabMaterialDto implements Serializable {
    private static final long serialVersionUID = 15834117231769102L;

    /**
     *
     *主键
     * not null default = null
     */
    private Long id;

    /**
     *
     *小图
     * max length = 255
     */
    private String smallImg;

    /**
     *
     *原图
     * max length = 512
     */
    private String sourceImg;

    /**
     *
     *内容
     * max length = 125
     */
    private String content;

    /**
     *
     *点赞数
     * not null default = 0
     */
    private Integer likeNum;

    /**
     *
     *评论数
     * not null default = 0
     */
    private Integer commentNum;

    /**
     *
     *grab_web表ID
     */
    private Long webId;

    /**
     *
     *原文发布时间
     */
    private Date publishTime;

    /**
     *
     *原文地址
     * max length = 255
     */
    private String sourceUrl;

    /**
     *
     *视频
     * max length = 512
     */
    private String sourceVideo;

    /**
     *
     *素材ID
     * max length = 125
     */
    private String uniqueId;

    /**
     *
     *创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     *
     *更新时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;

    /**
     * 评论列表
     */
    List<GrabMaterialCommentDto> commentDtoList;
}
