package cn.com.duiba.kjy.api.dto.home;

import lombok.Data;

import java.io.Serializable;

/**
 * @author wangbinbin
 * @create 2020-03-20 11:57
 * @descript 首页发圈素材列表dto
 */
@Data
public class MomentsMaterialDto implements Serializable {

    private static final long serialVersionUID = -1475875565341909416L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 发圈素材id, 对应tb_material_content_ext.id
     */
    private Long materialContentId;

    /**
     * 内容id，对应tb_content主键id
     */
    private Long contentId;

    /**
     * 内容标题
     */
    private String title;

    /**
     * 内容封面图
     */
    private String mainUrl;

    /**
     * 发圈素材类型
     */
    private Integer materialType;

    /**
     * 朋友圈配文
     */
    private String content;

    /**
     * 类型为图片的发圈素材图片列表
     */
    private String sourceImg;

    /**
     * 一级标签id 可能对应多个只取第一个
     */
    private Long firstTagId;

    /**
     * 发圈素材标签名称
     */
    private String tagName;

    /**
     * 发圈素材标签图片
     */
    private String tagImg;

    /**
     * 类型为视频的发圈素材视频地址
     */
    private String sourceVideo;

    /**
     * 视频封面图
     */
    private String videoImg;

    /**
     * 链接标题
     */
    private String videoTitle;

    /**
     * 文章/动画/测试id源
     */
    private Long sourceContentId;

    /**
     * 内容类型
     * @see cn.com.duiba.kjy.api.enums.version.ContentVersionEnum
     */
    private Integer contentVersion;

    /**
     * 原文地址
     */
    private String sourceUrl;

}
