package cn.com.duiba.kjy.api.params.exclusive;

import cn.com.duiba.kjy.api.enums.exclusive.ExclusiveAreaItemStateEnum;
import cn.com.duiba.kjy.api.params.PageQuery;
import lombok.Data;

import java.util.List;

/**
 * @author zhanghuifeng
 * date 2019-04-29-20:08
 */
@Data
public class ExclusiveAreaItemQryParams extends PageQuery {

    private static final long serialVersionUID = 5931996241802559739L;

    /**
     * 专区ID
     */
    private Long exclusiveAreaId;

    /**
     * 内容标题
     */
    private String title;

    /**
     * 1=有效;2=无效;3=未处理
     * @see ExclusiveAreaItemStateEnum
     */
    private Integer state;

    /**
     * 专区内容类型
     */
    private String itemType;

    /**
     * 一级标签id
     * 用于在es中查询相应内容
     */
    private Long firstTagId;

    /**
     * 素材的 id列表
     * tb_content.id
     * 202005  首页改版后 公司专区不支持素材外的内容
     * 如需添加素材外的内容 请移步公司资料库
     */
    private List<Long> itemIds;

    /**
     * 素材id
     */
    private Long itemId;

}
