package cn.com.duiba.kjy.api.dto.autoreply;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 自动回复内容表
 * @author kjj mybatis generator 
 * 2020-03-02
 */
@Data
public class AutoReplyConfigDto implements Serializable {
    private static final long serialVersionUID = 15831383585418431L;

    /**
     *
     *主键
     * not null default = null
     */
    private Long id;

    /**
     *
     *自动回复表ID，对应tb_auto_reply主键id
     * not null default = null
     */
    private Long autoReplyId;

    /**
     *
     *1:客服文字消息 2:客服图片消息 6:客服卡片消息，详见 MessageTypeEnum
     * not null default = null
     */
    private Integer messageType;

    /**
     *
     *标题
     * max length = 255
     */
    private String title;

    /**
     *
     *描述
     * max length = 255
     */
    private String pushDesc;

    /**
     *
     *缩略图
     * max length = 255
     */
    private String mainImgUrl;

    /**
     *
     *跳转地址
     * max length = 255
     */
    private String jumpPath;

    /**
     *
     *客服文字消息的内容
     * max length = 800
     */
    private String customWords;

    /**
     *
     *图片消息的微信返回的ID
     * max length = 255
     */
    private String picMediaId;

    /**
     *
     *小程序卡片消息的小程序ID
     */
    private Long mpId;

    /**
     *
     *是否删除，1=已删除，0=未删除
     * not null default = 0
     */
    private Integer deleted;

    /**
     *
     *创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     *
     *更新时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;
}