package cn.com.duiba.kjy.api.enums.orderRefund;

import java.util.HashMap;
import java.util.Map;

/**
 * @author xiaotian
 * @date 2020/4/22 11:09 AM
 */
public enum OrderCheckEnum {

    INI(0, "待审核"),
    SUCCESS(1,"退款通过"),
    FAIL(2,"退款拒绝"),
    CANCEL(3, "取消"),
    ;

    private Integer code;
    private String desc;

    OrderCheckEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getDesc() {
        return desc;
    }

    public Integer getCode() {
        return code;
    }

    private static final Map<Integer, OrderCheckEnum> ENUM_MAP = new HashMap<>();

    static{
        for(OrderCheckEnum tmp : values()){
            ENUM_MAP.put(tmp.getCode(), tmp);
        }
    }

    public static OrderCheckEnum getByCode(Integer code) {
        return ENUM_MAP.get(code);
    }
}
