package cn.com.duiba.kjy.api.remoteservice.explosioncontent;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.explosionContentQuestion.ExplosionContentQuestionDto;
import cn.com.duiba.kjy.api.dto.explosionContentQuestion.ExplosionContentQuestionRelationDto;
import cn.com.duiba.kjy.api.params.Page;
import cn.com.duiba.kjy.api.params.explosionContent.QAPageQryParams;

import java.util.List;

/**
 * 爆款素材问答服务
 * Created by hong
 * time 2020/1/6 20:28.
 */
@AdvancedFeignClient
public interface RemoteExplosionQuestionService {
    /**
     * 新增
     *
     * @param dto
     * @return
     */
    Boolean add(ExplosionContentQuestionDto dto);

    /**
     * 分页查询
     *
     * @param params
     * @return
     */
    Page<ExplosionContentQuestionDto> findPageList(QAPageQryParams params);

    /**
     * 关键词检索
     * @param params
     * @return
     */
    Page<ExplosionContentQuestionDto> findPageListLikeQuestionOrAnswer(QAPageQryParams params);

    /**
     * 编辑
     *
     * @param dto
     * @return
     */
    Boolean update(ExplosionContentQuestionDto dto);

    /**
     * 删除
     *
     * @param id
     * @return
     */
    Boolean deleteById(Long id);


    /**
     * 通过问答id查询爆款素材数量
     * @param qaId 问答id
     * @return
     */
    int findCountByQAid(Long qaId);

    /**
     * 通过文章id查询问答
     * @param contentId 文章id
     * @return
     */
    List<ExplosionContentQuestionDto> getQuestions(Long contentId, Integer personalLetter);

    /**
     * 通过收藏id查询问答
     * @param collectionId 收藏id
     * @return
     */
    List<ExplosionContentQuestionDto> getQuestionsByCollectionId(Long collectionId);

    /**
     * 通过问答id查询问答
     * @param id 答id
     * @return
     */
    ExplosionContentQuestionDto getExplosionQAById(Long id);

    /**
     * 根据爆款素材id查询问答
     * @param explosionId
     * @return
     */
    List<ExplosionContentQuestionRelationDto> selectList(Long explosionId);

    /**
     * 根据爆款素材id获取私信小科普id
     * @param explosionId
     * @return
     */
    Long getKnowledgeId(Long explosionId);

    /**
     * 根据ids获取FAQ问题
     * @param ids
     * @return
     */
    List<ExplosionContentQuestionDto> listByIds(List<Long> ids);

    /**
     * 根据问题查询建议
     * @param question
     * @return
     */
    String getAdviseByQuestion(String question);

    /**
     * 根据id列表查询问答列表
     * @param ids
     * @return
     */
    List<ExplosionContentQuestionDto> getQuestionListByIdList(List<Long> ids);

}
