package cn.com.duiba.kjy.api.enums.orderRefund;

import java.util.HashMap;
import java.util.Map;

/**
 * @author xiaotian
 * @date 2020/4/22 11:09 AM
 */
public enum RefundTypeEnum {

    /**
     * 退还差额
     */
    DISCOUNT(0, "退还差额"),
    /**
     * 全额退款
     */
    ALL(1,"全额退款"),
    /**
     * 部分退款
     */
    OTHER(2,"部分退款"),
    ;

    private Integer code;
    private String desc;

    RefundTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getDesc() {
        return desc;
    }

    public Integer getCode() {
        return code;
    }

    private static final Map<Integer, RefundTypeEnum> ENUM_MAP = new HashMap<>();

    static{
        for(RefundTypeEnum tmp : values()){
            ENUM_MAP.put(tmp.getCode(), tmp);
        }
    }

    public static RefundTypeEnum getByCode(Integer code) {
        return ENUM_MAP.get(code);
    }
}
