package cn.com.duiba.kjy.api.enums.version;

import java.util.Objects;

/**
 * 代理人vip版本枚举类
 * @author 吴文哲
 * @date 2020-02-05 09:31
 **/
public enum UserVersionEnum {

    COMMON_VERSION(1,"通用版"),
    INSURANCE_VERSION(2,"保险专业版"),
    EDU_VERSION(3,"教培专业版"),
    TEST_VERSION(99,"测试专用版")
    ;
    /**
     * 是否启用
     */
    private Integer version;
    /**
     * 描述
     */
    private String desc;

    UserVersionEnum(Integer version, String desc) {
        this.version = version;
        this.desc = desc;
    }

    public Integer getVersion() {
        return version;
    }

    public String getDesc() {
        return desc;
    }

    public static UserVersionEnum getByVersion(Integer version){
        for (UserVersionEnum enumVal : UserVersionEnum.values()) {
            if (Objects.equals(version, enumVal.getVersion())) {
                return enumVal;
            }
        }
        return null;
    }
}
