package cn.com.duiba.kjy.api.enums.sellergift;

import java.util.Objects;

/**
 * 用户奖励发放类别
 * @author xiaotian
 * @date 2020-06-16 09:31
 * 1:直播培训奖励 2:用户拜访权益 3:成功案例奖励
 **/
public enum GiftFromSourceEnum {

    /**
     * vip时长
     */
    LIVE(1,"直播培训奖励"),
    VISIT(2,"用户拜访权益"),
    SUCCESS(3,"成功案例奖励")
    ;

    private Integer code;

    private String desc;

    GiftFromSourceEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static GiftFromSourceEnum getByCode(Integer code){
        for (GiftFromSourceEnum enumVal : GiftFromSourceEnum.values()) {
            if (Objects.equals(code, enumVal.getCode())) {
                return enumVal;
            }
        }
        return null;
    }

    public static GiftFromSourceEnum getByDesc(String desc){
        for (GiftFromSourceEnum enumVal : GiftFromSourceEnum.values()) {
            if (Objects.equals(desc, enumVal.getDesc())) {
                return enumVal;
            }
        }
        return null;
    }
}
