package cn.com.duiba.kjy.api.remoteservice.sellergift;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.sellerGift.SellerGiftDto;
import cn.com.duiba.kjy.api.params.Page;
import cn.com.duiba.kjy.api.params.sellerGift.SellerGiftPageQueryParam;

import java.util.List;

/**
 * 功能描述：用户奖励发放
 *
 * @Auther: xiaotian
 * @Date: 2020/6/16 15:26
 * @Description:
 */
@AdvancedFeignClient
public interface RemoteSellerGiftService {


    /**
     * 批量修改
     * @param sellerGiftDtos
     * @return
     */
    boolean batchUpdate(List<SellerGiftDto> sellerGiftDtos);

    /**
     * 批量插入
     * @param sellerGiftDtos
     * @return
     */
    boolean batchInsert(List<SellerGiftDto> sellerGiftDtos);

    /**
     * 列表筛选
     * @param sellerGiftPageQueryParam
     * @return
     */
    Page<SellerGiftDto> pageQuery(SellerGiftPageQueryParam sellerGiftPageQueryParam);

    /**
     * 发放奖励
     * @param ids
     * @return
     */
    boolean grantGift(List<Long> ids);

}
