package cn.com.duiba.kjy.api.enums.sellerImport;


/**
 * @author xiaotian
 * 爬虫文章类型，外加默认图片
 */
public enum ImportSourceTypeEnum {
    /**
     * 百度文章
     */
    BAIDU(1,"https://yun.duiba.com.cn/kjy/image/20200604/14414c72.png"),

    /**
     * 快小编
     */
    KXB(2,"https://yun.duiba.com.cn/kjy/image/20200604/14414c72.png"),

    /**
     * 人民日报
     */
    PEOPLE(3,"https://yun.duiba.com.cn/kjy/image/20200604/14414c72.png"),

    /**
     * 新浪财经
     */
    SINA_FINANCE(4,"https://yun.duiba.com.cn/kjy/image/20200604/14414c72.png"),

    /**
     * 抖音视频
     */
    TIKTOK(5,"https://yun.duiba.com.cn/kjy/image/20200604/14414c72.png"),

    /**
     * 今日头条
     */
    TODAY_LINE(6,"https://yun.duiba.com.cn/kjy/image/20200604/14414c72.png"),

    /**
     * 人人都是产品经理
     */
    WO_SHI_PM(7,"https://yun.duiba.com.cn/kjy/image/20200604/14414c72.png"),

    /**
     * 微信公众号
     */
    WX_PLAT(8,"https://yun.duiba.com.cn/kjy/image/20200604/14414c72.png"),

    /**
     * 全网链接
     */
    NETWORK_LINK(9,"https://yun.duiba.com.cn/kjy/image/20200604/14414c72.png")
    ;

    ImportSourceTypeEnum(Integer code, String image) {
        this.code = code;
        this.image = image;
    }

    public static String getImageByCode(Integer code){
        for (ImportSourceTypeEnum importSourceTypeEnum : ImportSourceTypeEnum.values()){
            if(importSourceTypeEnum.getCode().equals(code)){
                return importSourceTypeEnum.getImage();
            }
        }
        return "https://yun.duiba.com.cn/kjy/image/20200604/14414c72.png";
    }

    private Integer code;
    private String image;

    public Integer getCode() {
        return code;
    }

    public String getImage() {
        return image;
    }
}
