package cn.com.duiba.kjy.api.remoteservice.tag;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.tag.ItemTagExtDto;
import cn.com.duiba.kjy.api.dto.tag.ItemTagDto;
import cn.com.duiba.kjy.api.enums.tag.TagItemTypeEnum;

import java.util.List;
import java.util.Map;

/**
 * item和标签关联关系service
 * @author zhanghuifeng
 * date 2019-04-11-15:11
 */
@AdvancedFeignClient
public interface RemoteItemTagService {

    /**
     * 根据标签集合获取存在的标签集合
     * @param tagIds
     * @return
     */
    List<Long> findExitTagIdsByTagIds(List<Long> tagIds);

    /**
     * 默认 type = content
     * @param itemIdList
     * @return
     * 兼容老版本存在，type 固定=content 后续如果需要请用 {@link cn.com.duiba.kjy.api.remoteservice.tag.RemoteItemTagService#findTagByItemIdsAndType }
     */
    @Deprecated
    Map<Long/*contentId*/, Map<Integer/*level*/, List<ItemTagExtDto>>> findTagByItemIds(List<Long> itemIdList);

    /**
     * 根据itemIds查询标签
     * @param itemIdList
     * @param type {@link cn.com.duiba.kjy.api.enums.TagTypeEnum}
     * @return
     */
    Map<Long, Map<Integer, List<ItemTagExtDto>>> findTagByItemIdsAndType(List<Long> itemIdList, TagItemTypeEnum type);

    /**
     * 根据itemId集合获取
     * @param itemIds
     * @param itemType {@link cn.com.duiba.kjy.api.enums.TagTypeEnum}
     *
     * @return
     */
    List<ItemTagDto> findByItemIds(List<Long> itemIds, Integer itemType);

    /**
     * 修改单个item 多个标签
     * 先删除所有关联，再添加
     * @param itemId
     * @param tagIds  tagIds.isEmpty() -> 删除所有标签
     * @param type {@link cn.com.duiba.kjy.api.enums.TagTypeEnum}
     * @return
     *
     * 兼容老版本存在，内部调用下面这个方法。
     */
    int updateItemTags(Long itemId, List<Long> tagIds, TagItemTypeEnum type);

    /**
     * 修改多个个item 多个标签
     * @param itemIds
     * @param tagIds
     * @param type {@link cn.com.duiba.kjy.api.enums.TagTypeEnum}
     * @return
     */
    int updateItemsTags(List<Long> itemIds, List<Long> tagIds, TagItemTypeEnum type);
}
